const express = require("express");

const adminRoute = require("./admin.route");
const siteRoute = require("./site.route");
const plotRoute = require("./plot.route");
const brokerRoute = require("./broker.route");
const generatequotationRouter = require("./generatequotationRouter.route");

const router = express.Router();

const defaultRoutes = [
  {
    path: "/admin",
    route: adminRoute,
  },
  {
    path: "/site",
    route: siteRoute,
  },
  {
    path: "/plot",
    route: plotRoute,
  },
  {
    path: "/broker",
    route: brokerRoute,
  },
  {
    path: "/generate",
    route: generatequotationRouter,
  },
];
defaultRoutes.forEach((route) => {
  router.use(route.path, route.route);
});

module.exports = router;
