const express = require("express");
const brokerRouter = express.Router();
const { brokerController } = require("../controllers");
const handleToken = require("../models/handleToken/handlerToken");

brokerRouter.post("/login", brokerController.Newbrokerlogin);
brokerRouter.get("/", handleToken, brokerController.getBroker);
brokerRouter.post("/add", handleToken, brokerController.addBroker);
brokerRouter.put("/:id", handleToken, brokerController.updateBroker);
brokerRouter.put(
  "/changePassword/:id",
  handleToken,
  brokerController.changePassword
);
brokerRouter.get("/delete/:id", handleToken, brokerController.deleteBroker);
brokerRouter.get("/status/:id", handleToken, brokerController.activateBroker);
brokerRouter.get("/status/:id", handleToken, brokerController.activateBroker);

brokerRouter.post("/assignSite", handleToken, brokerController.assignSite);
brokerRouter.get("/getSiteByBroker/:broker_id", handleToken, brokerController.getBrokerDashboard);

module.exports = brokerRouter;
