const { boolean } = require("joi");
const sequelize = require("./config");

const Plot = sequelize.define("plots", {
  plot_number: {
    type: String,
    required: true,
  },
  plot_area: {
    type: String,
    required: false,
  },
  plot_type: {
    type: String,
    required: false,
  },
  site_id: {
    type: Number,
    required: true,
  },
  amount: {
    type: Number,
    required: true,
  },
  total: {
    type: Number,
    required: true,
  },
  status: {
    type: String,
    required: true,
    defaultValue: "Unsold",
  },
  is_active: {
    type: boolean,
    required: true,
    default: true,
  },
  is_delete: {
    type: boolean,
    required: true,
    default: false,
  },
});

module.exports = Plot;
