const httpStatus = require("http-status");
require("dotenv").config();
const { Site, Plot } = require("../models");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");

const addPlot = async (req, res) => {
  try {
    const spkg = await Plot.findOne({
      where: {
        is_delete: false,
        plot_number: req.body.plot_number,
        site_id: req.body.site_id,
      },
    });

    if (spkg) {
      return res
        .status(httpStatus.BAD_REQUEST)
        .json({ msg: "Plot Number already Exist" });
    }

    req.body.is_active = 1;

    const plot = new Plot(req.body);
    const savedPlot = await plot.save();

    res
      .status(httpStatus.CREATED)
      .json({ msg: "Plot Added Successfully", plot: savedPlot });
  } catch (error) {
    console.error("Error saving plot data:", error);
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const getPlot = async (req, res) => {
  try {
    const spkg = await Plot.findAll({
      where: { is_delete: false },
    });
    await Promise.all(
      spkg.map(async (obj) => {
        // Fetch events for each event id
        const site = await Site.findOne({
          where: { id: obj.dataValues.site_id },
        });

        obj.dataValues.site = site;
      })
    );
    res
      .status(httpStatus.OK)
      .json({ msg: "Plot Fetch Successfully", plot: spkg });
  } catch (error) {
    console.error("Error saving plot data:", error);
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const getPlotById = async (req, res) => {
  try {
    const spkg = await Plot.findOne({
      where: { is_delete: false, id: req.params.id },
    });

    if (!spkg) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "Plot not found" });
    }
    const site = await Site.findOne({
      where: { id: spkg.dataValues.site_id },
    });

    spkg.dataValues.site = site;
    res
      .status(httpStatus.OK)
      .json({ msg: "Plot Fetch Successfully", plot: spkg });
  } catch (error) {
    console.error("Error saving plot data:", error);
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const updatePlot = async (req, res) => {
  try {
    const exist = await Plot.findOne({
      where: { is_delete: false, id: req.params.id },
    });
    if (!exist) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "Plot not found" });
    }

   
    const plot = await Plot.update(
      {
        ...req.body,
      },
      { where: { is_delete: false, id: req.params.id } }
    );
    const savedPlot = await Plot.findOne({
      where: { is_delete: false, id: req.params.id },
    });
    res
      .status(httpStatus.OK)
      .json({ msg: "Plot Update Successfully", plot: savedPlot });
  } catch (error) {
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const deletePlot = async (req, res) => {
  try {
    const exist = await Plot.findOne({
      where: { is_delete: false, id: req.params.id },
    });
    if (!exist) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "Plot not found" });
    }
  
    await Plot.update(
      { is_delete: true },
      { where: { id: req.params.id } }
    );

    res.status(httpStatus.OK).json({ msg: "Plot Delete Successfully" });
  } catch (error) {
    console.log(error)
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const activatePlot = async (req, res) => {
  try {
    const exist = await Plot.findOne({
      where: { is_delete: false, id: req.params.id },
    });
    if (!exist) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "Plot not found" });
    }
    const plot = await Plot.update(
      {
        is_active: !exist.dataValues.is_active,
      },
      { where: { is_delete: false, id: req.params.id } }
    );

    res.status(httpStatus.OK).json({ msg: "Plot Update Successfully" });
  } catch (error) {
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};


module.exports = {
  addPlot,
  getPlot,
  getPlotById,
  updatePlot,
  deletePlot,
  activatePlot,
};
