const jwt = require("jsonwebtoken");
const bcrypt = require("bcrypt");
const httpStatus = require("http-status");
require("dotenv").config();
const { superAdmin } = require("../models");

const getpassword = async (req, res) => {
  const password = "12345678";
  const hashedPassword = await bcrypt.hash(password, 10);
  //  console.log (hashedPassword);
  res.status(httpStatus.CREATED).json({ msg: hashedPassword });
};

const addAdmin = async (req, res) => {
  try {
    let exist = await superAdmin.findOne({
      where: { email: req.body.email },
    });
    if (exist) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Email Id Already Exist" });
    }

    req.body.is_active = 1;
    const hashedPassword = await bcrypt.hash(req.body.password, 10);
    req.body.password = hashedPassword;
    const admin = new superAdmin(req.body);
    await admin.save();
    res.status(httpStatus.CREATED).json({
      msg: `Admin Added Successfully`,
      data: admin,
    });
  } catch (error) {
    console.error("Error saving  data:", error);
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const updateAdmin = async (req, res) => {
  try {
    let admin = await superAdmin.findOne({
      where: { id: req.params.id },
    });
    if (admin.is_delete == true) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deleted" });
    }

    if (admin.is_active == false) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deactive" });
    }

    if (!admin) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "User not found" });
    }

    await superAdmin.update(
      {
        ...req.body,
      },
      { where: { id: req.params.id } }
    );

    const updateAdmin = await superAdmin.findOne({
      where: { id: req.params.id },
    });
    res.status(httpStatus.OK).json({
      msg: `Admin Update Successfully`,
      data: updateAdmin,
    });
  } catch (error) {
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const changePassword = async (req, res) => {
  try {
    let admin = await superAdmin.findOne({
      where: { id: req.params.id },
    });
    // const hashedPasswordOld = await bcrypt.hash(req.body.oldPassword, 10);
    const hashedPassword = await bcrypt.hash(req.body.password, 10);
    // console.log(hashedPasswordOld, admin.password);
    // if (hashedPasswordOld !== admin.password) {
    //   return res
    //     .status(httpStatus.FORBIDDEN)
    //     .json({ error: "Old Password is incorrect" });
    // }
    if (admin.is_delete == true) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deleted" });
    }

    if (admin.is_active == false) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deactive" });
    }
    if (!admin) {
      return res.status(httpStatus.BAD_REQUEST).json({ msg: "User not found" });
    }
    req.body.password = hashedPassword;
    await superAdmin.update(
      {
        password: hashedPassword,
      },
      { where: { id: req.params.id } }
    );

    const updateAdmin = await superAdmin.findOne({
      where: { id: req.params.id },
    });
    res.status(httpStatus.OK).json({
      msg: `Password Update Successfully`,
      data: updateAdmin,
    });
  } catch (error) {
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "Server error" });
  }
};

const Newadminlogin = async (req, res) => {
  try {
    const { email, password } = req.body;
    const admin = await superAdmin.findOne({
      where: { email: email },
    });

    if (!admin) {
      return res
        .status(httpStatus.BAD_REQUEST)
        .json({ msg: "Invalid Email Id" });
    }

    if (admin.is_delete == true) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deleted" });
    }

    if (admin.is_active == false) {
      return res
        .status(httpStatus.FORBIDDEN)
        .json({ error: "Your account is deactive" });
    }

    const isPasswordValid = await bcrypt.compare(password, admin.password);
    if (!isPasswordValid) {
      return res
        .status(httpStatus.BAD_REQUEST)
        .json({ msg: "Invalid password" });
    }
    const token = jwt.sign({ adminId: admin.id }, "Bearar");
    if (admin) {
      return res.status(httpStatus.OK).json({
        msg: `Welcome ${admin.company_name}`,
        token: token,
        data: admin,
      });
    }
  } catch (error) {
    res.status(httpStatus.INTERNAL_SERVER_ERROR).json({ msg: "server error" });
  }
};

module.exports = {
  getpassword,
  Newadminlogin,
  addAdmin,
  updateAdmin,
  changePassword,
};
